<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

$integro_template = apply_filters( 'integro_filter_get_template_part', integro_blog_archive_get_template() );

if ( ! empty( $integro_template ) && 'index' != $integro_template ) {

	get_template_part( $integro_template );

} else {

	integro_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$integro_stickies   = is_home()
								|| ( in_array( integro_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) integro_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$integro_post_type  = integro_get_theme_option( 'post_type' );
		$integro_args       = array(
								'blog_style'     => integro_get_theme_option( 'blog_style' ),
								'post_type'      => $integro_post_type,
								'taxonomy'       => integro_get_post_type_taxonomy( $integro_post_type ),
								'parent_cat'     => integro_get_theme_option( 'parent_cat' ),
								'posts_per_page' => integro_get_theme_option( 'posts_per_page' ),
								'sticky'         => integro_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $integro_stickies )
															&& count( $integro_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		integro_blog_archive_start();

		do_action( 'integro_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'integro_action_before_page_author' );
			get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'integro_action_after_page_author' );
		}

		if ( integro_get_theme_option( 'show_filters' ) ) {
			do_action( 'integro_action_before_page_filters' );
			integro_show_filters( $integro_args );
			do_action( 'integro_action_after_page_filters' );
		} else {
			do_action( 'integro_action_before_page_posts' );
			integro_show_posts( array_merge( $integro_args, array( 'cat' => $integro_args['parent_cat'] ) ) );
			do_action( 'integro_action_after_page_posts' );
		}

		do_action( 'integro_action_blog_archive_end' );

		integro_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'integro_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
