<?php
/**
 * The template to display default site footer
 *
 * @package INTEGRO
 * @since INTEGRO 1.0.10
 */

$integro_footer_id = integro_get_custom_footer_id();
$integro_footer_meta = get_post_meta( $integro_footer_id, 'trx_addons_options', true );
if ( ! empty( $integro_footer_meta['margin'] ) ) {
	integro_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( integro_prepare_css_value( $integro_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $integro_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $integro_footer_id ) ) ); ?>
						<?php
						$integro_footer_scheme = integro_get_theme_option( 'footer_scheme' );
						if ( ! empty( $integro_footer_scheme ) && ! integro_is_inherit( $integro_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $integro_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'integro_action_show_layout', $integro_footer_id );
	?>
</footer><!-- /.footer_wrap -->
