<?php
$integro_woocommerce_sc = integro_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $integro_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$integro_scheme = integro_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $integro_scheme ) && ! integro_is_inherit( $integro_scheme ) ) {
			echo ' scheme_' . esc_attr( $integro_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( integro_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( integro_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$integro_css      = '';
			$integro_bg_image = integro_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $integro_bg_image ) ) {
				$integro_css .= 'background-image: url(' . esc_url( integro_get_attachment_url( $integro_bg_image ) ) . ');';
			}
			if ( ! empty( $integro_css ) ) {
				echo ' style="' . esc_attr( $integro_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$integro_anchor_icon = integro_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$integro_anchor_text = integro_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $integro_anchor_icon ) || ! empty( $integro_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $integro_anchor_icon ) ? ' icon="' . esc_attr( $integro_anchor_icon ) . '"' : '' )
											. ( ! empty( $integro_anchor_text ) ? ' title="' . esc_attr( $integro_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( integro_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' integro-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$integro_css      = '';
				$integro_bg_mask  = integro_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$integro_bg_color_type = integro_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $integro_bg_color_type ) {
					$integro_bg_color = integro_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $integro_bg_color_type ) {
					$integro_bg_color = integro_get_scheme_color( 'bg_color', $integro_scheme );
				} else {
					$integro_bg_color = '';
				}
				if ( ! empty( $integro_bg_color ) && $integro_bg_mask > 0 ) {
					$integro_css .= 'background-color: ' . esc_attr(
						1 == $integro_bg_mask ? $integro_bg_color : integro_hex2rgba( $integro_bg_color, $integro_bg_mask )
					) . ';';
				}
				if ( ! empty( $integro_css ) ) {
					echo ' style="' . esc_attr( $integro_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$integro_caption     = integro_get_theme_option( 'front_page_woocommerce_caption' );
				$integro_description = integro_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $integro_caption ) || ! empty( $integro_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $integro_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $integro_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $integro_caption, 'integro_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $integro_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $integro_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $integro_description ), 'integro_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $integro_woocommerce_sc ) {
						$integro_woocommerce_sc_ids      = integro_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$integro_woocommerce_sc_per_page = count( explode( ',', $integro_woocommerce_sc_ids ) );
					} else {
						$integro_woocommerce_sc_per_page = max( 1, (int) integro_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$integro_woocommerce_sc_columns = max( 1, min( $integro_woocommerce_sc_per_page, (int) integro_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$integro_woocommerce_sc}"
										. ( 'products' == $integro_woocommerce_sc
												? ' ids="' . esc_attr( $integro_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $integro_woocommerce_sc
												? ' category="' . esc_attr( integro_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $integro_woocommerce_sc
												? ' orderby="' . esc_attr( integro_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( integro_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $integro_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $integro_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
