<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

$integro_template_args = get_query_var( 'integro_template_args' );

if ( is_array( $integro_template_args ) ) {
	$integro_columns    = empty( $integro_template_args['columns'] ) ? 2 : max( 1, $integro_template_args['columns'] );
	$integro_blog_style = array( $integro_template_args['type'], $integro_columns );
    $integro_columns_class = integro_get_column_class( 1, $integro_columns, ! empty( $integro_template_args['columns_tablet']) ? $integro_template_args['columns_tablet'] : '', ! empty($integro_template_args['columns_mobile']) ? $integro_template_args['columns_mobile'] : '' );
} else {
	$integro_template_args = array();
	$integro_blog_style = explode( '_', integro_get_theme_option( 'blog_style' ) );
	$integro_columns    = empty( $integro_blog_style[1] ) ? 2 : max( 1, $integro_blog_style[1] );
    $integro_columns_class = integro_get_column_class( 1, $integro_columns );
}
$integro_expanded   = ! integro_sidebar_present() && integro_get_theme_option( 'expand_content' ) == 'expand';

$integro_post_format = get_post_format();
$integro_post_format = empty( $integro_post_format ) ? 'standard' : str_replace( 'post-format-', '', $integro_post_format );

?><div class="<?php
	if ( ! empty( $integro_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( integro_is_blog_style_use_masonry( $integro_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $integro_columns ) : esc_attr( $integro_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $integro_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $integro_columns )
				. ' post_layout_' . esc_attr( $integro_blog_style[0] )
				. ' post_layout_' . esc_attr( $integro_blog_style[0] ) . '_' . esc_attr( $integro_columns )
	);
	integro_add_blog_animation( $integro_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$integro_hover      = ! empty( $integro_template_args['hover'] ) && ! integro_is_inherit( $integro_template_args['hover'] )
							? $integro_template_args['hover']
							: integro_get_theme_option( 'image_hover' );

	$integro_components = ! empty( $integro_template_args['meta_parts'] )
							? ( is_array( $integro_template_args['meta_parts'] )
								? $integro_template_args['meta_parts']
								: explode( ',', $integro_template_args['meta_parts'] )
								)
							: integro_array_get_keys_by_value( integro_get_theme_option( 'meta_parts' ) );

	integro_show_post_featured( apply_filters( 'integro_filter_args_featured',
		array(
			'thumb_size' => ! empty( $integro_template_args['thumb_size'] )
				? $integro_template_args['thumb_size']
				: integro_get_thumb_size(
					'classic' == $integro_blog_style[0]
						? ( strpos( integro_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $integro_columns > 2 ? 'big' : 'huge' )
								: ( $integro_columns > 2
									? ( $integro_expanded ? 'square' : 'square' )
									: ($integro_columns > 1 ? 'square' : ( $integro_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( integro_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $integro_columns > 2 ? 'masonry-big' : 'full' )
								: ($integro_columns === 1 ? ( $integro_expanded ? 'huge' : 'big' ) : ( $integro_columns <= 2 && $integro_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $integro_hover,
			'meta_parts' => $integro_components,
			'no_links'   => ! empty( $integro_template_args['no_links'] ),
        ),
        'content-classic',
        $integro_template_args
    ) );

	// Title and post meta
	$integro_show_title = get_the_title() != '';
	$integro_show_meta  = count( $integro_components ) > 0 && ! in_array( $integro_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $integro_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'integro_filter_show_blog_meta', $integro_show_meta, $integro_components, 'classic' ) ) {
				if ( count( $integro_components ) > 0 ) {
					do_action( 'integro_action_before_post_meta' );
					integro_show_post_meta(
						apply_filters(
							'integro_filter_post_meta_args', array(
							'components' => join( ',', $integro_components ),
							'seo'        => false,
							'echo'       => true,
						), $integro_blog_style[0], $integro_columns
						)
					);
					do_action( 'integro_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'integro_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'integro_action_before_post_title' );
				if ( empty( $integro_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'integro_action_after_post_title' );
			}

			if( !in_array( $integro_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'integro_filter_show_blog_readmore', ! $integro_show_title || ! empty( $integro_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $integro_template_args['no_links'] ) ) {
						do_action( 'integro_action_before_post_readmore' );
						integro_show_post_more_link( $integro_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'integro_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $integro_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('integro_filter_show_blog_excerpt', empty($integro_template_args['hide_excerpt']) && integro_get_theme_option('excerpt_length') > 0, 'classic')) {
			integro_show_post_content($integro_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $integro_template_args['more_button'] )) {
			if ( empty( $integro_template_args['no_links'] ) ) {
				do_action( 'integro_action_before_post_readmore' );
				integro_show_post_more_link( $integro_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'integro_action_after_post_readmore' );
			}
		}
		$integro_content = ob_get_contents();
		ob_end_clean();
		integro_show_layout($integro_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
