<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

// Page (category, tag, archive, author) title

if ( integro_need_page_title() ) {
	integro_sc_layouts_showed( 'title', true );
	integro_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								integro_show_post_meta(
									apply_filters(
										'integro_filter_post_meta_args', array(
											'components' => join( ',', integro_array_get_keys_by_value( integro_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', integro_array_get_keys_by_value( integro_get_theme_option( 'counters' ) ) ),
											'seo'        => integro_is_on( integro_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$integro_blog_title           = integro_get_blog_title();
							$integro_blog_title_text      = '';
							$integro_blog_title_class     = '';
							$integro_blog_title_link      = '';
							$integro_blog_title_link_text = '';
							if ( is_array( $integro_blog_title ) ) {
								$integro_blog_title_text      = $integro_blog_title['text'];
								$integro_blog_title_class     = ! empty( $integro_blog_title['class'] ) ? ' ' . $integro_blog_title['class'] : '';
								$integro_blog_title_link      = ! empty( $integro_blog_title['link'] ) ? $integro_blog_title['link'] : '';
								$integro_blog_title_link_text = ! empty( $integro_blog_title['link_text'] ) ? $integro_blog_title['link_text'] : '';
							} else {
								$integro_blog_title_text = $integro_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $integro_blog_title_class ); ?>">
								<?php
								$integro_top_icon = integro_get_term_image_small();
								if ( ! empty( $integro_top_icon ) ) {
									$integro_attr = integro_getimagesize( $integro_top_icon );
									?>
									<img src="<?php echo esc_url( $integro_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'integro' ); ?>"
										<?php
										if ( ! empty( $integro_attr[3] ) ) {
											integro_show_layout( $integro_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $integro_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $integro_blog_title_link ) && ! empty( $integro_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $integro_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $integro_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'integro_action_breadcrumbs' );
						$integro_breadcrumbs = ob_get_contents();
						ob_end_clean();
						integro_show_layout( $integro_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
